<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                            'Wishlist-id', 
                            'create date', 
                            'customer name', 
                            'customer moblie', 
                            'delivery mode',
                            'pick up name', 
                            'pick up moblie', 
                            'shipping charge', 
                            'packaging charge',
                            'payment charge', 
                            'coupon code', 
                            'coupon discount', 
                            'payment discount', 
                            'tax amount', 
                            'UTM ID', 
                            'UTM campaign', 
                            'Name', 
                            'mobile',
                            'Address',
                            'city', 
                            'state', 
                            'pincode', 
                            'SKU', 
                            'Item name',
                            'Item price'
                        ];
                    }

                    $query = "SELECT 
  w.wishlist_no,
  w.User_id,
  w.Product_id,
  w.date,
  w.removed_date,
  u.displayname AS Name,
  u.phoneno AS Phone,
  u.address AS Address,
  u.city AS City,
  u.state AS State,
  u.pincode AS Pincode,
  pd.Product_name,
  pd.SKU,
  pd.HSN,
  pd.Selling_price,
  pd.tax


FROM 
wish_list w

LEFT JOIN 
product pd
ON
w.Product_id = pd.Product_id
LEFT JOIN 
customer u
ON 
w.User_id = u.id 
WHERE 
w.Delete_status = 0
AND u.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Today") {
    $query .= " AND DATE(w.date) = CURDATE()";
} elseif ($duration == "Yesterday") {
    $query .= " AND DATE(w.date) = CURDATE() - INTERVAL 1 DAY";
} elseif ($duration == "Last Week") {
    $query .= " AND w.date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND w.date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND w.date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
    $filePath = 'reports/wishlist_report_' . time() . '.csv';
    $file = fopen($filePath, 'w');

    // Write the header row
    $header = [
        'Wishlist-id', 
        'create date', 
        'customer name', 
        'customer moblie', 
        'delivery mode',
        'pick up name', 
        'pick up moblie', 
        'shipping charge', 
        'packaging charge',
        'payment charge', 
        'coupon code', 
        'coupon discount', 
        'payment discount', 
        'tax amount', 
        'UTM ID', 
        'UTM campaign', 
        'Name', 
        'mobile',
        'Address',
        'city', 
        'state', 
        'pincode', 
        'SKU', 
        'Item name',
        'Item price'
    ];

    fputcsv($file, $header);

    // Write data rows
    foreach ($data as $row) {
        


        fputcsv($file, [
            $row['wishlist_no'],              
            $row['date'], 
            $row['Name'],
            $row['Phone'],
            '',
            '',
            '',
            '0.0',
            '0.0',                        
            '0.0', 
            '0.0', 
            '0.0',               
           '0.0',     
           $row['tax'], 
           '-',
           '-',
           $row['Name'],
           $row['Phone'],
           $row['Address'],
           $row['City'],
           $row['State'],
           $row['Pincode'],
           $row['SKU'],
           $row['Product_name'],
           $row['Selling_price']        
          
        ]);
    }

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo','Wishlist Report', NOW(), '$durationText', '$finalpath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/wishlist_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(1150, 700));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Wishlist-id', 
    'create date', 
    'customer name', 
    'customer moblie', 
    'delivery mode',
    'pick up name', 
    'pick up moblie', 
    'shipping charge', 
    'packaging charge',
    'payment charge', 
    'coupon code', 
    'coupon discount', 
    'payment discount', 
    'tax amount', 
    'UTM ID', 
    'UTM campaign', 
    'Name', 
    'mobile',
    'Address',
    'city', 
    'state', 
    'pincode', 
    'SKU', 
    'Item name',
    'Item price'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 45); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
$values = [
    $row['wishlist_no'],              
    $row['date'], 
    $row['Name'],
    $row['Phone'],
    '',
    '',
    '',
    '0.0',
    '0.0',                        
    '0.0', 
    '0.0', 
    '0.0',               
   '0.0',     
   $row['tax'], 
   '-',
   '-',
   $row['Name'],
   $row['Phone'],
   $row['Address'],
   $row['City'],
   $row['State'],
   $row['Pincode'],
   $row['SKU'],
   $row['Product_name'],
   $row['Selling_price']        
          
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo','Wishlist Report', NOW(), '$durationText', '$finalpath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}
                }
            }
            ?>